//
//  MiscMergeCondition.h 
//    Written by Carl Lindberg Copyright 2000 by Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	
//  This file formatted with 4 spaces per tabstop.

#import <Foundation/NSObject.h>
#import "MiscMergeCommand.h"

@class NSArray;
@class MiscMergeEngine;

@interface MiscMergeCondition : NSObject
{
}

- (BOOL)evaluateWithEngine:(MiscMergeEngine *)anEngine;

- (NSString *)description;
- (NSString *)descriptionWithGroupParentheses:(BOOL)showParens;

@end

@interface MiscMergeCondition (ParsingExtras)

+ (MiscMergeCondition *)conditionWithString:(NSString *)aString;

@end


@interface MiscMergeSimpleCondition : MiscMergeCondition
{
    NSString *leftField;
    MiscMergeConditionalOperator operator;
    NSString *rightField;
}

- (id)initWithLeftField:(NSString *)leftArg;
- (id)initWithLeftField:(NSString *)leftArg
               operator:(MiscMergeConditionalOperator)anOperator
             rightField:(NSString *)rightArg;

- (NSString *)leftField;
- (NSString *)rightField;
- (MiscMergeConditionalOperator)operator;
- (NSString *)operatorString;

@end


@interface MiscMergeAndCondition : MiscMergeCondition
{
    NSArray *conditionArray;
}

- (id)initWithConditionArray:(NSArray *)conditions;
- (NSArray *)conditions;

@end

@interface MiscMergeOrCondition : MiscMergeCondition
{
    NSArray *conditionArray;
}

- (id)initWithConditionArray:(NSArray *)conditions;
- (NSArray *)conditions;

@end

@interface MiscMergeNotCondition : MiscMergeCondition
{
    MiscMergeCondition *condition;
}

- (id)initWithCondition:(MiscMergeCondition *)aCondition;
- (MiscMergeCondition *)condition;

@end
